/* sccsid[] = "@(#) $Id: //bas/46D/src/include/crfcserv.h#3 $ SAP" */   
//

// SAP RFC C++ Class library.
// Copyright (C) 1996 SAP America, Inc.
// All rights reserved.
                        

////////////////////////////////////////////////////////////////////////////////
//  File crfcserv.h
////////////////////////////////////////////////////////////////////////////////

#ifndef CRFCSERV__H
#define CRFCSERV__H

#include "crfcglob.h"
#include "crfcfunc.h"

#ifdef _WIN32

#include <tchar.h>

#define CRFCSERV_CONSTRUCTOR \
            _T("CRfcServerFunc::CRfcServerFunc (CSTR) called")
#define CRFCSERV_DESTRUCTOR \
            _T("CRfcServerFunc::~CRfcServerFunc() called")
#define CRFCSERV_RAISE \
            _T("CRfcServerFunc::Raise called")
#define CRFCSERV_RAISETABLES \
            _T("CRfcServerFunc::RaiseTables called")
#define CRFCSERV_PROCESS \
            _T("CRfcServerFunc::Process called")
#define CRFCSERV_GETDESCRIPTION \
            _T("CRfcServerFunc::GetDescription called")
#define CRFCSERV_RECEIVEDATA \
            _T("CRfcServerFunc::ReceiveData called")
#define CRFCSERV_RETURNCALL \
            _T("CRfcServerFunc::ReturnCall called")
#define CRFCSERV_CLONE \
 			_T("You have to implement the clone function CRfcServerFunc::clone() in the derived class of CRfcServerFunc.")
#define CRFCSERV_CALLRECEIVE \
            _T("CRfcServerFunc::CallReceive called") 
#define AUTO_SERVER_CREATION_FAILURE_MSG \
            _T("Auto-creation of server function object failed")
#else

#define CRFCSERV_CONSTRUCTOR \
            "CRfcServerFunc::CRfcServerFunc (CSTR) called"
#define CRFCSERV_DESTRUCTOR \
            "CRfcServerFunc::~CRfcServerFunc() called"
#define CRFCSERV_RAISE \
            "CRfcServerFunc::Raise called"
#define CRFCSERV_RAISETABLES \
            "CRfcServerFunc::RaiseTables called"
#define CRFCSERV_PROCESS \
            "CRfcServerFunc::Process called"
#define CRFCSERV_GETDESCRIPTION \
            "CRfcServerFunc::GetDescription called"
#define CRFCSERV_RECEIVEDATA \
            "CRfcServerFunc::ReceiveData called"
#define CRFCSERV_RETURNCALL \
            "CRfcServerFunc::ReturnCall called"
#define CRFCSERV_CLONE \
 			"You have to implement the clone function CRfcServerFunc::clone() in the derived class of CRfcServerFunc."
#define CRFCSERV_CALLRECEIVE \
            "CRfcServerFunc::CallReceive called"  
#define AUTO_SERVER_CREATION_FAILURE_MSG \
            "Auto-creation of server function object failed"
#endif


class CRfcConnection;
class CRfcServerApp;

////////////////////////////////////////////////////////////////////////////////
// CRfcServerFunc class declaration 

class CRfcServerFunc : public CRfcFunction
{
  // constructor & destructor 
public:
    // Constructor throws const char* for memory exceptions.
   // CRfcServerFunc (CSTR strFunctionName);

	//  Constructor for auto-creating parameter objects from the R/3 system metadata
	//  Constructor throws const char* for memory exceptions.
	CRfcServerFunc (CSTR strFuncName, 
#ifdef SAPonNT
		            bool bAutoCreate=FALSE,
#else
                    BOOL bAutoCreate=FALSE,
#endif
	                const CRfcConnection* pServerConnection=NULL, CSTR strServerFuncName=NULL);

    virtual ~CRfcServerFunc(void);

#if defined(CRFCwithTHREADS)
	virtual CRfcServerFunc *  clone();  //  Make a copy for the object
                        //  This must be implemented in the derived classes in order to make multithreading work
#endif

  // operations                     
    RFC_RC       Raise(char* strException);
    // Raise exceptions on the tables in the function
    // The function itself may throw const char* for memory exception.
    RFC_RC       RaiseTables(char* strException) ; 

    // These function set and get the pointer to the parent CRfcServerApp
    //  class that contains this CRfcServerFunc object
    void                 SetServerApp(CRfcServerApp* pServerApp) { m_pServerApp = pServerApp; }
    const CRfcServerApp* GetServerApp(void) { return m_pServerApp; }

    //Overwritables
    // Pure virtual function to be implemented by inherited classes.
    // This should contain all necessary function-specific data processing.
    virtual void Process (void) = 0; 

    // Returns description about the server function
    virtual char* GetDescription (void) ; 

    // The following functions may raise RFC_ERROR_INFO_EX exceptions 
    // when executing RfcGetData or RfcSendData
    // Throws const char* for memory exception,
    //        and RFC_ERROR_INFO_EX for RfcGetData failures.
    virtual RFC_RC       ReceiveData (void);
    // Throws const char* for memory exception,
    //        and RFC_ERROR_INFO_EX for RfcSendData failures.
    virtual RFC_RC       ReturnCall  (void);     
	//  The following CallReceive function is used to communicate with R/3 system
	//  and get the data from the R/3 system.  It is not used to communicate with 
	//  the the RFC client calling this RFC server.  There are two RFC connections
	//  in the auto creating RFC servers.  One is used to listen to the RFC clients
	//  and the other is used to get the RFC function metadata from some R/3 system.
	RFC_RC CallReceive   (char*& strException, BOOL bPassAllParams=FALSE);
#if defined(CRFCwithTHREADS)
	void MultipleThreadDataProcess(void);
#endif
	 //  Get data, process data, and then send data to the calling client.

  // attributes
protected:

#ifdef SAPonNT
		            bool m_bServerParamsWereAutoCreated;
#else
                    BOOL m_bServerParamsWereAutoCreated;
#endif

//  The following two fields are for RFC server function, the RFC server also connects with 
//  the R/3 system automatically to get the metadat such as the internal table structure.  In
//  this case, the parameters for the function will be automatically generated by the class
//  library according to the metadata in the R/3 system.
	CRfcString                  m_rstrServerFuncName;
	const CRfcConnection*       m_pServerConnection;

    const CRfcServerApp*      m_pServerApp;
  

	CRfcServerFunc (const CRfcServerFunc& sourceServer);
    CRfcServerFunc& operator=( const CRfcServerFunc& sourceServer );

};                                            

#endif          //CRFCSERV__H
